/*---------------------------------------------------------------------------*\

    FILE....: RECWAV.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 6/6/01

    This program takes a line off hook and records a wave file.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"

int arg_exists(int argc, char *argv[], char *arg);
void record_get_hw_gain(int handle, float *gain); 
void record_get_sw_gain(int handle, float *gain); 

int main(int argc, char * argv[])
{
	int	        h;
	VPB_RECORD	record;
	int             arg;
	int             mode;
	int             ch_num, ports_per_card;

	if (argc < 4) {
		printf("usage: %s WaveFile ChNum[1..] Secs "
		       "[--recgain GaindB] [--onhook] "
		       "[--mode [linear | alaw | mulaw | adpcm] "
		       "[--dial Number]"
		       "\n"
		       ,argv[0]);
		exit(0);
	}

	//verbose(1);
	record.term_digits = "";
	record.time_out = atoi(argv[3])*1000;

	vpb_seterrormode(VPB_DEVELOPMENT);
	h = vpb_open(1,1);
	ports_per_card = vpb_get_ports_per_card();
	vpb_close(h);

	ch_num = atoi(argv[2]);
	h = vpb_open(1 + ((ch_num-1)/ports_per_card),1+ ((ch_num-1)%ports_per_card));

	// optionally set record gain
	if ((arg = arg_exists(argc, argv, "--recgain")) != 0) {
		vpb_record_set_gain(h, (float)atof(argv[arg+1]));      	
		printf("record gain set to = %f\n", atof(argv[arg+1]));
		float gain;
		record_get_hw_gain(h, &gain);
		printf("hw record gain  = %f\n", gain);
		record_get_sw_gain(h, &gain);
		printf("sw record gain  = %f\n", gain);
	}

	// optionally set mode
	mode = VPB_LINEAR;
	if ((arg = arg_exists(argc, argv, "--mode")) != 0) {
	  if (!strcmp(argv[arg+1], "linear"))
	    mode = VPB_LINEAR;
	  if (!strcmp(argv[arg+1], "alaw"))
	    mode = VPB_ALAW;
	  if (!strcmp(argv[arg+1], "mulaw"))
	    mode = VPB_MULAW;
	  if (!strcmp(argv[arg+1], "adpcm"))
	    mode = VPB_OKIADPCM;
	}

	vpb_record_set(h, &record);
	if (!arg_exists(argc, argv, "--onhook")) {
		vpb_sethook_sync(h, VPB_OFFHOOK);
	}
	if ((arg = arg_exists(argc, argv, "--dial")) != 0) {
		vpb_dial_sync(h, argv[arg+1]);
	}
	vpb_record_file_sync(h, argv[1], mode);
	vpb_sethook_sync(h, VPB_ONHOOK);

	vpb_close(h);

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}


